<?php
    // vars
    $testimonial_title = get_field('testimonial_title',$lid);
?>
<div class="col-md-12">
    <h2><?php echo $testimonial_title; ?></h2>
</div>

<div class="row row-content">
    <?php 
        //while(have_rows('testimonial_lists',$lid)): the_row(); 
        //$rating = get_sub_field('testimonials_rating');
    ?>
    <?php
    // The Query
    $args = array(
        'post_type'   => 'testimonials',
        'posts_per_page' => -1,
    );
    $the_query = new WP_Query( $args );
    if ( $the_query->have_posts() ) {
        while ( $the_query->have_posts() ) {
            $the_query->the_post();
            $reviewer_name = get_field('reviewer_name');
            $reviewer_email = get_field('reviewer_email');
            $review_title = get_field('review_title');
            $review_content = get_field('review_content');
            $review_rating = get_field('review_rating');
            $review_date = get_the_date('m/d/y');
        ?>
            <div class="col-sm-6">
                <blockquote>
                    <div class="blockquote-ratings">
                      <?php for($i=1; $i<= $review_rating; $i++){ ?>
                        <i class="fa fa-star" aria-hidden="true"></i>
                      <?php } ?>
                    </div>
                    <q><?php echo $review_content; ?></q>
                    <cite><?php echo $reviewer_name; ?></cite>
                    <date><?php echo $review_date; ?></date>
                </blockquote>
            </div>    
        <?php
        }
        wp_reset_postdata();
    }
    ?>
    
    <?php //endwhile; ?>

    <?php /*===== Testimonial Form ====*/ ?>
    <div class="col-xs-12 testimonial_form">
        <?php if(isset($error) && (!empty($error)))
        {
            ?>
            <div class="alert alert-danger form_error">
                <?php
                foreach($error as $err)
                {
                    ?>
                    <span><?php echo $err; ?></span>
                    <?php 
                }
                ?>
            </div>
            <?php
        }
        ?>
        <?php if(isset($success) && (!empty($success)))
        {
            ?>
            <div class="alert alert-success form_success">
                <?php
                foreach($success as $suc)
                {
                    ?>
                    <span><?php echo $suc; ?></span>
                    <?php 
                }
                ?>
            </div>
            <?php
        }
        ?>
        

        <form method="POST" action="" name="review_form">
            
            <div class="form-group">
                <label for="reviwer_name">Name</label>
                <input type="text" class="form-control" name="reviwer_name" id="reviwer_name" value="" required />
            </div>
            <div class="form-group">
                <label for="reviwer_email">Email</label>
                <input type="email" class="form-control" name="reviwer_email" id="reviwer_email" value="" required />
            </div>
            <div class="form-group">
                <label for="review_title">Review Title</label>
                <input type="text" class="form-control" name="review_title" id="review_title" value="" required />
            </div>
            <div class="form-group">
                <label for="rating">Rating</label>
                <select class="form-control" name="rating" id="rating">
                  <option>5</option>
                  <option>4</option>
                  <option>3</option>
                  <option>2</option>
                  <option>1</option>
                </select>
            </div>
            <div class="form-group">
                <label for="review_content">Review Content</label>
                <textarea class="form-control" name="review_content" id="review_content" rows="3" required></textarea>
            </div>

            <input type="submit" name="reviw_submit" class="btn btn-lg btn-novo" value="Submit" />
            
        </form>
    </div>
</div>