<?php
// Register Custom Post Type - patient success story
register_post_type( 'cpt_patient_story',
    array(
    'labels' => array(
        'name'                => _x( 'Stories', 'Stories', 'text_domain' ),
        'singular_name'       => _x( 'Story Item', 'Story Item', 'text_domain' ),
        'menu_name'           => __( 'Patient Stories', 'text_domain' ),
        'name_admin_bar'      => __( 'Stories', 'text_domain' ),
        'parent_item_colon'   => __( 'Stories:', 'text_domain' ),
        'all_items'           => __( 'All Stories', 'text_domain' ),
        'add_new_item'        => __( 'Add New Story', 'text_domain' ),
        'add_new'             => __( 'Add Story', 'text_domain' ),
        'new_item'            => __( 'New Story', 'text_domain' ),
        'edit_item'           => __( 'Edit Story', 'text_domain' ),
        'update_item'         => __( 'Update Story', 'text_domain' ),
        'view_item'           => __( 'View Story', 'text_domain' ),
        'search_items'        => __( 'Search Stories', 'text_domain' ),
        'not_found'           => __( 'No Stories found', 'text_domain' ),
        'not_found_in_trash'  => __( 'No Stories found in Trash', 'text_domain' ),
    ),

    'label'               => __( 'Stories', 'text_domain' ),
    'description'         => __( 'Patient Success Stories Description', 'text_domain' ),
    'supports'            => array('title','editor','thumbnail','excerpt'),
    // 'taxonomies'          => array( 'category', 'post_tag' ),
    'hierarchical'        => false,
    'public'              => true,
    'show_ui'             => true,
    'show_in_menu'        => true,
    'menu_position'       => 45,
    'menu_icon'           => 'dashicons-pressthis',
    'show_in_admin_bar'   => true,
    'show_in_nav_menus'   => true,
    'can_export'          => true,
    'has_archive'         => true,
    'exclude_from_search' => false,
    'publicly_queryable'  => true,
    'capability_type'     => 'post',
    'rewrite'             => array( 'slug'=>'patient-success-stories' ),
    )
);
?>
