<?php

/**
 * Adds Foo_Widget widget.
 */
class LatestPosts extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		parent::__construct(
			'latest_posts', // Base ID
			esc_html__( 'Latest Posts', 'text_domain' ), // Name
			array( 'description' => esc_html__( 'A Latest Posts Widget', 'text_domain' ), ) // Args
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		echo $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
		}
		// echo esc_html__( 'Hello, World!', 'text_domain' );

      $query = array(
        'post_type'       => 'post',
        'posts_per_page'  => 3,
        'orderby'         => 'title',
        'order'           => 'ASC'

      );
      ?>

      <ul class="widget-latestposts">
        <?php $latestposts = new WP_Query($query); while($latestposts->have_posts()): $latestposts->the_post(); ?>
          <li class="clearfix">
            <div class="widget-latestposts-header">
                <?php the_post_thumbnail('thumbnail'); ?>
                <h3>
                  <a class=""
                     href="<?php the_permalink(); ?>"
                     title="<?php the_title(); ?>"><?php the_title(); ?></a>
                </h3>
            </div>
            <div class="widget-latestposts-excerpt">
              <?php the_excerpt(); ?>
            </div>
            <div class="widget-latestposts-link">
              <a class=""
                 href="<?php the_permalink(); ?>"
                 title="Read More">Read More</a>
            </div>
          </li>
        <?php endwhile; wp_reset_postdata(); ?>
      </ul>

		<?php echo $args['after_widget'];
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
		$title = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( 'New title', 'text_domain' );
		?>
		<p>
		<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_attr_e( 'Title:', 'text_domain' ); ?></label>
		<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
		</p>
		<?php
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

		return $instance;
	}

} // class LatestPosts

// register LatestPosts widget
function register_latest_posts() {
    register_widget( 'LatestPosts' );
}
add_action( 'widgets_init', 'register_latest_posts' );
