<?php
/**
 * @package Rockwall_v1.0
 */
get_header(); ?>

<div class="wrapper wpagetitle">
<div class="container cpagetitle">

	<section class="row clearfix">
		<div class="col-xs-12">
			<h1 class="page_title">
				Search results 
			</h1>
		</div>
	</section>
						
</div>
</div>

<div class="wrapper wbody">
<div class="container cbody">
	<div class="page_content">

	<section class="row">

	<main id="primary" class="site-main col-md-8" role="main">

		<?php if ( have_posts() ) : ?>
				<header class="page-header">
					<h2 class="page-title">
						<?php printf( esc_html__( 'Search Results for: %s', 'rockwallv1' ), '<span>' . get_search_query() . '</span>' ); ?>
					</h2>
				</header>
			<?php while ( have_posts() ) : the_post();
					get_template_part( 'template-parts/content/content', 'search' );
				  endwhile;
			?>
			
			<!-- Pagination -->
			<div class="pager">
				<?php
				    global $wp_query;
				    $big = 999999999; // need an unlikely integer
				    echo paginate_links( array(
				        'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
				        'format' => '?paged=%#%',
				        'current' => max( 1, get_query_var('paged') ),
				        'prev_text'          => __('«'),
						'next_text'          => __('»'),
				        'total' => $wp_query->max_num_pages
				    ) );
				     wp_reset_query();
				?>
			</div>

			<?php
			  else :
				get_template_part( 'template-parts/content/content', 'none' );
			  endif; 
		?>

	</main>

	<?php get_sidebar(); ?>
	
	</section>
	</div>
</div>
</div>

<?php get_footer();?>
