<?php
/**
 * @package _liquidbase
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <h2 class="screen-reader-text"><?php the_title(); ?></h2>
	<?php if ( has_post_thumbnail()) : ?>
			<figure class="">
				<?php the_post_thumbnail( '', array( 'class' => 'img-fluid' ) ); ?>
			</figure>
	<?php endif; ?>

	<?php if ( 'post' === get_post_type() ) : ?>
		<div class="entry-meta">
			<span class="posted-on">
				<label class="entry-text-posted">Posted on: </label>
				<span class="entry-date"><?php echo get_the_date('F j, Y'); ?></span> 
				<span class="entry-by-text">by</span> 
				<span class="entry-author"><?php echo get_the_author(); ?></span>
			</span> 
					
			</span>
			<span class="posted-in">
				<?php 
					$categories_list = get_the_category_list( esc_html__( ', ') );
					if ( $categories_list) {
						printf( '<span class="cat-links">' . esc_html__( 'Posted in %1$s') . '</span>', $categories_list ); // WPCS: XSS OK.
					}
				?>
			</span> 
			<span class="posted-tags">
				<?php
					echo get_the_tag_list('<span class="tag-links">Tags: ',', ','</span>');
				?>
			</span>
		</div>
	<?php endif; ?>

	<div class="entry-content">
		<?php the_content( sprintf(
				/* translators: %s: Name of current post. */
				wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'rockwallv1' ), array( 'span' => array( 'class' => array() ) ) ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			  ) );

			  wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'rockwallv1' ),
				'after'  => '</div>',
			 ) );
		?>
	</div>
	
</article>
