<?php if( have_rows('team_member_repeater') ): ?>
<?php while( have_rows('team_member_repeater') ): the_row(); 

	// vars
	$team_name = get_sub_field('team_member_name');
	$team_title = get_sub_field('team_member_title');
	$team_phone = get_sub_field('team_member_phone');
	$team_email = get_sub_field('team_member_email');
	$team_photo = get_sub_field('team_member_photo');
	$team_website = get_sub_field('team_website');
	$team_bio = get_sub_field('team_member_bio');
?>
	<article class="category_list clearfix">
		<div class="row clearfix">
			<div class="col-sm-4 summary-left">
				<?php if( !empty($team_photo) ): ?>
					<figure>
	                    <img title="<?php echo $team_photo['title']; ?>" alt="<?php echo $team_photo['alt']; ?>" src="<?php echo $team_photo['url']; ?>">
					</figure>
				<?php endif; ?>
			</div>
			
			<div class="col-sm-8 summary-right">
				<?php if($team_name) : ?>
					<h2 class="article-title"><?php echo $team_name; ?></h2>
				<?php endif; ?>
				<?php if($team_title) : ?>
					<p class="team-title">
						<?php echo $team_title; ?>
					</p>
				<?php endif; ?>
				<?php if($team_phone) : ?>
				<p class="team-phone">
					<a href="tel:<?php echo $team_phone; ?>" title="<?php echo $team_phone; ?>">
						<?php echo $team_phone; ?>
					</a>
				</p>
				<?php endif; ?>
				<?php if($team_email) : ?>
				<p class="team-email">
					<a href="mailto:<?php echo $team_email; ?>" title="<?php echo $team_email; ?>">
						<?php echo $team_email; ?>
					</a>
				</p>
				<?php endif; ?>
				<?php if($team_bio) : ?>
					<?php echo $team_bio; ?>
				<?php endif; ?>
				
			</div>
			
		</div>
	</article>
	
<?php endwhile; ?>
<?php endif; ?>