<?php
/*
 * Template Name: The Team
 */
get_header(); ?>
<div class="wrapper wpagetitle">
    <div class="container cpagetitle">
        <section class="row clearfix">
            <div class="col-md-12">
                <?php the_title( '<h1 class="page_title">', '</h1>' ); ?>
            </div>
        </section>
                            
    </div>
</div>
<div class="wrapper wbody">
    <div class="container cbody">
        <div class="page_content">
            <main id="primary" class="team-main-block col-md-12">
                <?php
                while ( have_posts() ) : the_post();
                        get_template_part( 'template-parts/content/content', 'page' );
                        
                endwhile;
                ?>
                <?php 
				/*===== Member Name List Start ====*/ 
				$taxonomies = get_terms( array(
					'taxonomy' => 'staff-categories',
					'hide_empty' => false,
				) );
				?>
                <ul class="nav nav-tabs" id="TeamMembers" role="tablist">
					<?php $cat = 1; foreach( $taxonomies as $category ) : ?>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link <?php if($cat==1): ?> active <?php endif; ?>" id="physicians-tab" data-toggle="tab" data-target="#<?php echo $category->slug; ?>" type="button" role="tab"><?php echo $category->name; ?></button>
                    </li>
                    <?php $cat++; endforeach; ?>
                </ul>
                <?php /*===== Member Name List End ====*/ ?>

                <div class="tab-content" id="TeamMembersContent">
                    <?php /*===== Member Tab Start ====*/ ?>
					 <?php $tax=1; foreach( $taxonomies as $term ) : ?>
                    <div class="tab-pane fade show <?php if($tax==1): ?> active <?php endif; ?>" id="<?php echo $term->slug; ?>">
                        <h2><?php echo $term->slug; ?></h2>
                        <div class="row member-block">
							<?php 
							$args = array(
							'post_type' => 'cpt_lsmcstaff',
							'posts_per_page' => -1,
							'order' => "ASC",
							'tax_query' => array(
								array(
									'taxonomy' => 'staff-categories',
									'field' => 'slug',
									'terms' => $term->slug
								)
							)
						);
						$query = new WP_Query( $args );
						while($query->have_posts()): $query->the_post();
							$image_url = wp_get_attachment_url( get_post_thumbnail_id() );
							?>
                            <div class="col-12 col-md-4 member-inner">
                                <a href="javascript:void(0);" style="background-image:url(<?php echo $image_url; ?>); " class="member-link" title="<?php the_title(); ?>">
                                    <span class="screen-reader-text"><?php the_title(); ?></span>
                                </a>
								<h3><?php the_title(); ?></h3>
                                <div class="member-meta">
									
									<?php if(get_the_content()): ?>
									<span><i class="fas fa-caret-down"></i></span>
                                    <div class="member-caption">
										<h4><?php the_title(); ?></h4>
                                        <p><?php echo get_the_excerpt(); ?></p>
										<a href="<?php the_permalink(); ?>" class="btn bio-btn" title="">Read Bio</a>
                                    </div>
                                     <?php endif; ?>        
                                </div>
                            </div>
							<?php endwhile; wp_reset_query(); ?>
                        </div>
                    </div>
					<?php $tax++; endforeach; ?>
                    <?php /*===== Member Tab End ====*/ ?>

					
                
                </div>

            </main>
      
    </div>
</div>
<?php //get_sidebar(); ?>
<?php get_footer(); ?>