<?php
/**
 * @package _liquidbase
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('row mt-5 mb-5'); ?>>
    <div class="col-12 col-md-4 doctor-image text-center">
	<?php if ( has_post_thumbnail()) : ?>
			<figure class="">
				<?php the_post_thumbnail( '', array( 'class' => 'img-fluid' ) ); ?>
			</figure>
            <div class="doctor-contact">
                <a href="<?php echo get_permalink(28); ?>" title="Schedule a consultation" class="btn btn-primary">Schedule a consultation</a>
            </div>
	<?php endif; ?>
	</div>	
	<div class="col-12 col-md-8 doctor-content">
        <h2><?php the_title(); ?></h2>
		<?php the_content(); ?>



		<div id="accordion">
			<?php if(have_rows('education_list')): ?>
			<div class="card">
				<div class="card-header">
					<a class="card-link"
						data-toggle="collapse"
						href="#description1">
						Education & Qualification
					</a>
				</div>
				<div id="description1"
					class="collapse show"
					data-parent="#accordion">
					<div class="card-body">
						<?php while(have_rows('education_list')): the_row(); ?>
						<p><i class="fas fa-stethoscope"></i>  <?php echo get_sub_field('add_degree'); ?></p>
						<?php endwhile; ?>
					</div>
				</div>
			</div>
			<?php endif; ?>	
			<?php if(have_rows('achievement_list')): ?>
			<div class="card">
				<div class="card-header">
					<a class="collapsed card-link"
						data-toggle="collapse"
						href="#description2">
						Achievement 
					</a>
				</div>
				<div id="description2" class="collapse"
					data-parent="#accordion">
					<div class="card-body">
					   <?php while(have_rows('achievement_list')): the_row(); ?>
						<p><i class="fas fa-stethoscope"></i>  <?php echo get_sub_field('achievement_item'); ?></p>
						<?php endwhile; ?>
					</div>
				</div>
			</div>
			<?php endif; ?>	
		</div>
	 </div>



	</div>
</article>
