<?php

class widget_for_get_page_data extends WP_Widget {

    function __construct() {
        parent::__construct(
                'widget_for_get_page_data', __('Show Page Data', 'widgetpageall'), array('description' => __('Add Widget that show page data', 'widgetpageall'),)
        );
    }

    public function widget($args, $instance) {
        echo $args['before_widget'];
        $title = apply_filters('widget_title', get_the_title($instance['page_name']));
        if (!empty($title))
            echo $args['before_title'] . $title . $args['after_title'];
        ?>
        <div class="textwidget custom-html-widget">
            <?php
            $post_info = get_post($instance['page_name']);
            $excerpt = $post_info->post_excerpt;
            ?>
            <p><?php echo $excerpt; ?>...</p>
            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#bookingform">Book Now!</button>
        </div>
        <?php
        echo $args['after_widget'];
    }

    public function form($instance) {
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('page_name'); ?>"><?php _e('Select Page Name:'); ?></label> 
            <?php
            $args = array(
                'sort_order' => 'asc',
                'sort_column' => 'post_title',
                'hierarchical' => 1,
                'post_type' => 'page',
            );
            $pages = get_pages($args);
            if(!empty($instance['page_name'])){
                $selected = $instance['page_name'];
            }else{
                $selected = 'selected';
            }
            ?>
            <select id="<?php echo $this->get_field_id('page_name'); ?>" name="<?php echo $this->get_field_name('page_name'); ?>" class="widefat" style="width:100%;">
        <?php foreach ($pages as $page) { ?>
                    <option <?php selected($selected, $page->ID); ?> value="<?php echo $page->ID; ?>"><?php echo $page->post_title; ?></option>
        <?php } ?>      
            </select>
        </p>
        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['page_name'] = (!empty($new_instance['page_name']) ) ? strip_tags($new_instance['page_name']) : '';
        return $instance;
    }

}

function widgetpageall_get_page_data() {
    register_widget('widget_for_get_page_data');
}

add_action('widgets_init', 'widgetpageall_get_page_data');