<?php
/*
 * Template Name: Career Recruiting
 */
get_header(); ?>
<div class="wrapper wpagetitle">
    <div class="container cpagetitle">
        <section class="row clearfix">
            <div class="col-md-12">
                <?php the_title( '<h1 class="page_title">', '</h1>' ); ?>
            </div>
        </section>
    </div>
</div>
<div class="wrapper wbody">
    <div class="container cbody">
        <div class="page_content">
            <main id="primary" class="site-main col-md-12 career-wrapper">
                
                    <div class="row">

                       <div class="col-12 text-center clinic-title mt-3 mb-3">
                            <h2><?php echo get_field('clinic_title'); ?></h2>
                        </div>

                        <?php /*============= Clinic Gallery =========*/ ?>
                        <div class="col-12 clinic-wrapper mb-5">
                        <?php
                            while ( have_posts() ) : the_post();
                                    get_template_part( 'template-parts/content/content', 'page' );
                            endwhile;
                        ?>
                                <div class="slider mt-3">
                                    <div class="owl-carousel owl-theme one">
                                        
                                        <?php 
                                        $clinic_gallery = get_field('clinic_gallery');
                                        foreach($clinic_gallery as $clinic_gallery_img): 
                                        ?>
                                        <div style="background-image: url(<?php echo $clinic_gallery_img['url']; ?>)" class="item-box"></div>
                                        <?php endforeach; ?>

                                    </div>
                                    <div class="left nonl"></div>
                                    <div class="right"></div>
                                </div>
                                <div class="slider-two">
                                    <div class="owl-carousel owl-theme two">
                                        <?php $i=1; foreach($clinic_gallery as $clinic_gallery_thumb): ?>
                                        <div style="background-image: url(<?php echo $clinic_gallery_thumb['url']; ?>)" class="item <?php if($i==1): echo "active"; endif; ?>"></div>
                                        <?php $i++; endforeach; ?>
                    
                                    </div>
                                    <div class="left-t nonl-t"></div>
                                    <div class="right-t"></div>
                                </div>
                            <?php /*============= Clinic Gallery =========*/ ?>
                            <hr>
                        </div>

                        <div class="col-12 text-center community-title mb-3">
                            <h2><?php echo get_field('community_title'); ?></h2>
                        </div>

                        <?php /*============= Community Gallery =========*/ ?>
                        <div class="col-12  community-wrapper">
                            <?php echo get_field('community_content'); ?>
                           
                                <div class="slider mt-3">
                                    <div class="owl-carousel owl-theme one">
                                        
                                        <?php 
                                        $community_gallery_images = get_field('community_gallery');
                                        foreach($community_gallery_images as $community_gallery_img): 
                                        ?>
                                        <div style="background-image: url(<?php echo $community_gallery_img['url']; ?>)" class="item-box"></div>
                                        <?php endforeach; ?>

                                    </div>
                                    <div class="left nonl"></div>
                                    <div class="right"></div>
                                </div>
                                <div class="slider-two">
                                    <div class="owl-carousel owl-theme two">
                                        <?php $i=1; foreach($community_gallery_images as $community_gallery_thumb): ?>
                                        <div style="background-image: url(<?php echo $community_gallery_thumb['url']; ?>)" class="item <?php if($i==1): echo "active"; endif; ?>"></div>
                                        <?php $i++; endforeach; ?>
                    
                                    </div>
                                    <div class="left-t nonl-t"></div>
                                    <div class="right-t"></div>
                                </div>
                            <?php /*============= Community Gallery =========*/ ?>
                        </div>

                    </div>

                   <?php if(have_rows('community_sponsors')): ?>
                   <div class="row justify-content-center  mt-3">

                        <?php 
                        while(have_rows('community_sponsors')): the_row(); 
                        //Var
                        $upload_sponsor = get_sub_field('upload_sponsor');
                        ?>
                        <div class="col-6 col-md-3 mb-3">
                            <a href="" title="">
                                <img src="<?php echo $upload_sponsor; ?>" alt="" title="" >
                            </a>
                        </div>
                        <?php endwhile; ?>

                   </div>
                   <?php endif; ?>


                <?php get_template_part( 'template-parts/content/content', 'attachment-repeater' ); ?>
                <?php get_template_part( 'template-parts/content/content', 'page-repeater' ); ?>
            </main>
    </div>
</div>

<?php get_footer(); ?>