<?php
/*
 * Template Name: LSMC Testimonials
 */
get_header(); ?>
<div class="wrapper wpagetitle">
    <div class="container cpagetitle">

        <section class="row clearfix">
            <div class="col-md-12">
                <?php the_title( '<h1 class="page_title">', '</h1>' ); ?>
            </div>
        </section>
                            
    </div>
</div>
<div class="wrapper wbody">
    <div class="container cbody">
        <div class="page_content">
            <main id="primary" class="site-main col-md-12">
                <?php

                while ( have_posts() ) : the_post();
                        get_template_part( 'template-parts/content/content', 'page' );
                        
                endwhile;
                ?>

                <div class="testimonial-wrapper">
                    <?php if(get_field('testimonial_title')): ?>
                    <h2>
                        <?php the_field('testimonial_title'); ?>
                    </h2>
                    <?php endif; ?>

                    <div id="customers-testimonials" class="owl-carousel">

                        <?php 
                        while(have_rows('testimonial_lists')): the_row(); 
                        //Var

                        $testimonial_name = get_sub_field('testimonial_name');
                        $testimonial_image = get_sub_field('testimonial_image');
                        $testimonial_quote = get_sub_field('testimonial_caption');

                        ?>
                        <!--TESTIMONIAL  -->
                        <div class="item">
                        <div class="shadow-effect">
                            <img class="img-circle" src="<?php echo $testimonial_image ?>" alt="<?php echo $testimonial_name; ?>">
                            <?php echo $testimonial_quote ?>
                        </div>
                        <div class="testimonial-name"><?php echo $testimonial_name; ?></div>
                        </div>
                        <!--END OF TESTIMONIAL  -->

                        <?php endwhile; ?>
                        
                    </div>

                </div>

                <?php get_template_part( 'template-parts/content/content', 'attachment-repeater' ); ?>
                <?php get_template_part( 'template-parts/content/content', 'page-repeater' ); ?>

            </main>
      
    </div>
</div>
<?php //get_sidebar(); ?>
<?php get_footer(); ?>