<?php
/*
Plugin Name: Landing Page
Plugin URI: http://liquidsg.com/
Description: Custom post type for Landing page
Author: Liquid Studio Group
Version: 1.0
Author URI: http://liquidsg.com/
*/
/**
 *
 * Register post type
 *
 */
 if (!defined('LANPATH')) {
    define('LANPATH', plugin_dir_path(__FILE__));
}

// ===== CPT: Landing Pages =====//
if ( !post_type_exists('landing_pages') ) {
	function register_show_type() {
		$label_singular = 'Landing Page';
		$label_plural   = 'Landing Page';
		register_post_type(
			'landing_pages',
			array(
				'label'           => $label_plural,
				'description'     => '',
				'public'          => true,
				'show_ui'         => true,
				'show_in_menu'    => true,
				'capability_type' => 'page',
				'hierarchical'    => false,
				'query_var'       => true,
				'has_archive'     => true,
				'rewrite' => array(
					'slug'       => 'landing',
				),
				'supports' => array(
					'title',
				),
				'labels' => array (
					'name'               => $label_plural,
					'singular_name'      => $label_singular,
					'menu_name'          => $label_plural,
					'add_new'            => 'Add New',
					'add_new_item'       => 'Add New ' . $label_singular,
					'edit'               => 'Edit',
					'edit_item'          => 'Edit ' . $label_singular,
					'new_item'           => 'New ' . $label_singular,
					'view'               => 'View ' . $label_singular,
					'view_item'          => 'View ' . $label_singular,
					'search_items'       => 'Search ' . $label_plural,
					'not_found'          => 'No ' . $label_plural . ' Found',
					'not_found_in_trash' => 'No ' . $label_plural . ' Found in Trash',
					'parent'             => 'Parent ' . $label_singular,
				)
			)
		);
	}
	add_action('init', 'register_show_type');
}

// ===== CPT: Testimonials =====//
/*
if ( !post_type_exists('testimonials') ) {
	function register_testimonial_type() {
		$label_singular = 'Testimonial';
		$label_plural   = 'Testimonials';
		register_post_type(
			'testimonials',
			array(
				'label'           => $label_plural,
				'description'     => '',
				'public'          => true,
				'show_ui'         => true,
				'show_in_menu'    => true,
				'capability_type' => 'page',
				'hierarchical'    => false,
				'query_var'       => true,
				'has_archive'     => true,
				'menu_icon'		  => 'dashicons-groups',	
				'rewrite' => array(
					'slug'       => 'testimonials',
				),
				'supports' => array(
					'title',
				),
				'labels' => array (
					'name'               => $label_plural,
					'singular_name'      => $label_singular,
					'menu_name'          => $label_plural,
					'add_new'            => 'Add New',
					'add_new_item'       => 'Add New ' . $label_singular,
					'edit'               => 'Edit',
					'edit_item'          => 'Edit ' . $label_singular,
					'new_item'           => 'New ' . $label_singular,
					'view'               => 'View ' . $label_singular,
					'view_item'          => 'View ' . $label_singular,
					'search_items'       => 'Search ' . $label_plural,
					'not_found'          => 'No ' . $label_plural . ' Found',
					'not_found_in_trash' => 'No ' . $label_plural . ' Found in Trash',
					'parent'             => 'Parent ' . $label_singular,
				)
			)
		);
	}
	add_action('init', 'register_testimonial_type');
}
*/

// ===== Include As a Front Page =====//

add_filter( 'template_include', 'landi_page_template', 99 );
function landi_page_template( $template ) {
	if ( 'landing_pages' == get_post_type() ) {
		 return mlsp_get_template_hierarchy('single-landing_pages');
	}
	return $template;
}

function mlsp_get_template_hierarchy($template) {

    $template_slug = rtrim($template, '.php');
    $template = $template_slug . '.php';

    $file = LANPATH . '/templates/' . $template;
    

		return apply_filters('mlsp_repl_template_' . $template, $file);
}

///// Google Fonts ////////////////////////
function landing_load_fonts() {
     wp_register_style(
         'googleFonts', 
         'https://fonts.googleapis.com/css?family=Oswald:300,400,700');
     wp_enqueue_style( 'googleFonts');

     wp_register_style(
         'googleFonts1', 
         'https://fonts.googleapis.com/css?family=Open+Sans+Condensed:300,300i,700');
     wp_enqueue_style( 'googleFonts1');
     
 }
 add_action('wp_print_styles', 'landing_load_fonts');

// ===== Include Landing Page Style =====//
function lan_load_css_js() {
    $plugin_url = plugin_dir_url(__FILE__);
    wp_enqueue_style('lan_style', $plugin_url . 'assets/style.css');
}

add_action('wp_enqueue_scripts', 'lan_load_css_js');


// ===== ACF Field Groups Code =====//

require_once(LANPATH . '/templates/landing-acf-fields.php');

// ===== Gravity Form =====//

//define( 'GF_THEME_IMPORT_FILE', LANPATH . 'assets/form/gravityforms-export.json' );