<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCaL1Eiv9C1jHgKcE097QutleOuS4XBTsQ&callback=initMap"></script>

<script type="text/javascript">
/**=========== Map Script =============**/
var geocoder = new google.maps.Geocoder();
<?php
  
    //Var......
    $add_map_title = get_field('add_map_title', $lid);
    $add_map_location = get_field('add_map_location', $lid); 
    $map_overlay_color = get_field('map_overlay_color', $lid); 

?> 
var address = "<?php echo $add_map_location; ?>";  
var title = "<?php echo $add_map_title; ?>";
var latitude;
var longitude;
var color = "<?php echo $map_overlay_color; ?>"; //Set your tint color. Needs to be a hex value.

function getGeocode() {
    geocoder.geocode( { 'address': address}, function(results, status) {
        if (status == google.maps.GeocoderStatus.OK) {
            latitude = results[0].geometry.location.lat();
            longitude = results[0].geometry.location.lng(); 
            initGoogleMap();
        } 
    });
}

function initGoogleMap() {
    var styles = [
        {
          stylers: [
            { saturation: -100 }
          ]
        }
    ];
    
    var options = {
        mapTypeControlOptions: {
            mapTypeIds: ['Styled']
        },
        center: new google.maps.LatLng(latitude, longitude),
        zoom: 15,
        scrollwheel: false,
        navigationControl: false,
        mapTypeControl: false,
        zoomControl: true,
        disableDefaultUI: true, 
        mapTypeId: 'Styled'
    };
    var div = document.getElementById('google-map');
    var map = new google.maps.Map(div, options);
    marker = new google.maps.Marker({
        map:map,
        draggable:false,
        animation: google.maps.Animation.DROP,
        position: new google.maps.LatLng(latitude,longitude)
    });
    var styledMapType = new google.maps.StyledMapType(styles, { name: 'Styled' });
    map.mapTypes.set('Styled', styledMapType);
    
    var infowindow = new google.maps.InfoWindow({
          content: "<div><h6>" + title + "</h6><p>" + address + "</div></p></div>"
    });
    
    google.maps.event.addListener(marker, 'mouseover', function() {
        infowindow.open(map,marker);
    });
        
    
    bounds = new google.maps.LatLngBounds(
      new google.maps.LatLng(-84.999999, -179.999999), 
      new google.maps.LatLng(84.999999, 179.999999));

    rect = new google.maps.Rectangle({
        bounds: bounds,
        fillColor: color,
        fillOpacity: 0.2,
        strokeWeight: 0,
        map: map
    });

    var listener = google.maps.event.addListener(map, "idle", function() { 
      google.maps.event.removeListener(listener); 
    });

}
google.maps.event.addDomListener(window, 'load', getGeocode);
       
</script>
